' Ce dlgu encapsule un pointeur sur fonction
' vers une mthode prenant un objet Car en paramtre et
' retournant un type void.
' public delegate void CarDelegate(Car c)

public class Garage
    ' Nous disposons de quelques voitures.
    Private theCars As ArrayList = New ArrayList()

    Public Sub New()
        theCars.Add(New Car("Viper", 100, 0, True, False))
        theCars.Add(New Car("Fred", 100, 0, False, False))
        theCars.Add(New Car("BillyBob", 100, 0, False, True))
        theCars.Add(New Car("Bart", 100, 0, True, True))
        theCars.Add(New Car("Stan", 100, 0, False, True))
    End Sub

    ' Cette mthode prend en paramtre un objet CarDelegate.
    ' Par consquent, 'proc' ne fait que pointer sur une fonction...
    Public Sub ProcessCars(ByVal proc As Car.CarDelegate)
        ' O passons-nous l'appel ?
        Dim d As [Delegate]
        For Each d In proc.GetInvocationList()
            Console.WriteLine("***** Appel de : {0} *****", _
            d.Method.ToString())
        Next

        ' Est-ce que j'appelle une mthode d'objet ou une mthode partage ?
        If (Not proc.Target Is Nothing) Then
            Console.WriteLine("-->Cible : {0}", proc.Target)
        Else
            Console.WriteLine("-->La cible et une mthode partage nomme {0}", _
               proc.Method)
        End If
        ' Maintenant on appelle la mthode pour chaque voiture.
        Dim c As Car
        For Each c In theCars
            proc(c)
        Next
        Console.WriteLine()
    End Sub
End Class